<?php
// Script independiente para guardar tokens y enviar notificaciones Expo
// Requiere WordPress para acceder a la DB
require "./wp-load.php";

// CONFIG
$EXPO_URL = "https://exp.host/--/api/v2/push/send";

// ===============
// GUARDAR TOKEN
// ===============
if (isset($_GET["action"]) && $_GET["action"] === "save") {
    // Espera POST con user_id y expo_token
    $user_id    = intval($_POST["user_id"] ?? 0);
    $expo_token = trim($_POST["expo_token"] ?? "");

    header("Content-Type: application/json; charset=utf-8");

    if ($user_id <= 0 || $expo_token === "") {
        http_response_code(400);
        echo json_encode(["ok"=>false, "error"=>"Faltan parámetros"]);
        exit;
    }

    update_user_meta($user_id, "expo_push_token", $expo_token);
    echo json_encode(["ok"=>true, "user_id"=>$user_id, "expo_token"=>$expo_token]);
    exit;
}

// ===============
// ENVIAR PUSH
// ===============
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["send_push"])) {
    $title  = trim($_POST["title"] ?? "");
    $body   = trim($_POST["body"] ?? "");
    $uids   = $_POST["uids"] ?? [];

    $tokens = [];
    foreach ($uids as $uid) {
        $t = get_user_meta(intval($uid), "expo_push_token", true);
        if ($t) $tokens[] = $t;
    }

    if ($title && $body && $tokens) {
        $messages = [];
        foreach ($tokens as $tk) {
            $messages[] = [
                "to"    => $tk,
                "title" => $title,
                "body"  => $body,
            ];
        }
        // Enviar en chunks de 100
        $chunks = array_chunk($messages, 100);
        foreach ($chunks as $chunk) {
            $resp = wp_remote_post($EXPO_URL, [
                "headers" => [
                    "Accept" => "application/json",
                    "Content-Type" => "application/json"
                ],
                "body"    => json_encode($chunk),
                "timeout" => 20
            ]);
            // Para debug
            // error_log(print_r($resp,true));
        }
        $msg = "Notificaciones enviadas a ".count($tokens)." usuario(s).";
    } else {
        $msg = "Faltan datos para enviar.";
    }
}

// ===============
// INTERFAZ HTML
// ===============
$users = get_users([
    "meta_key" => "expo_push_token",
    "number"   => 500
]);
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Expo Push</title>
<style>
body { font-family: sans-serif; margin:20px; }
table { border-collapse: collapse; width:100%; margin-top:10px;}
th,td { border:1px solid #ccc; padding:6px; }
</style>
</head>
<body>
<h1>Expo Push – Enviar notificaciones</h1>

<?php if (!empty($msg)) echo "<p><strong>$msg</strong></p>"; ?>

<form method="post">
    <p>
        <label>Título:<br>
        <input type="text" name="title" style="width:100%" required></label>
    </p>
    <p>
        <label>Mensaje:<br>
        <textarea name="body" rows="3" style="width:100%" required></textarea></label>
    </p>
    <h3>Usuarios con token</h3>
    <table>
        <tr><th></th><th>ID</th><th>Usuario</th><th>Email</th><th>Token</th></tr>
        <?php foreach ($users as $u): 
            $tok = get_user_meta($u->ID, "expo_push_token", true);
            if (!$tok) continue;
        ?>
        <tr>
            <td><input type="checkbox" name="uids[]" value="<?php echo $u->ID ?>"></td>
            <td><?php echo $u->ID ?></td>
            <td><?php echo esc_html($u->user_login) ?></td>
            <td><?php echo esc_html($u->user_email) ?></td>
            <td style="word-break:break-all;"><?php echo esc_html($tok) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
    <p>
        <button type="submit" name="send_push">Enviar notificaciones</button>
    </p>
</form>
</body>
</html>